/* 
 * mycp.c 
 *
 * Копіює заданий файл, використовуючи механізм відображення
 * файлів на пам'ять.
 * Ілюструє порядок застосування механізму відображення файлів на пам'ять.
 *
 */

#include <errno.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


int main(int argc, char *argv[])
{
        int sfd, dfd;           /* Файлові дескриптори */
        caddr_t saddr, daddr;
        struct stat st;

        if (argc != 3) {
                /* Перший аргумент - ім'я оригінального файлу,
                   другий - цільового (копії) */
                fprintf(stderr, "Usage: %s source dest\n", argv[0]);
                exit(EXIT_FAILURE);
        }

        /* Відкриває оригінальний файл. */
        sfd = open(argv[1], O_RDONLY);
        if (sfd < 0) {
                perror("open()");
                exit(EXIT_FAILURE);
        }

        /* Відкриває цільовий файл. */
        dfd = open(argv[2], O_RDWR | O_CREAT | O_EXCL, 00664);
        if (dfd < 0) {
                if (errno == EEXIST)
                        fprintf(stderr, "Error opening target file:"
                                                " File exists\n");
                else
                        perror("open()");
                exit(EXIT_FAILURE);
        }

        /* Отримує атрибути оригінального файлу. */
        if (fstat(sfd, &st) < 0) {
                perror("fstat()");
                exit(EXIT_FAILURE);
        }

        /* Робить розмір цільового файлу рівним розміру оригінального. */
        if (lseek(dfd, st.st_size - 1, SEEK_SET) < 0) {
                perror("lseek()");
                exit(EXIT_FAILURE);
        }
        if (write(dfd, "", 1) < 0) {
                perror("write()");
                exit(EXIT_FAILURE);
        }

        /* Відображує файли на пам'ять. */
        saddr = mmap((caddr_t) 0, st.st_size, PROT_READ,
                                                MAP_SHARED, sfd, 0);
        if (saddr != MAP_FAILED)
                daddr = mmap((caddr_t) 0, st.st_size, PROT_WRITE,
                                                MAP_SHARED, dfd, 0);
        if ((saddr == MAP_FAILED) || (daddr == MAP_FAILED)) {
                perror("mmap()");
                exit(EXIT_FAILURE);
        }

        /* Копіює дані. */
        memcpy(daddr, saddr, st.st_size);

        /* Повний успіх */
        exit(EXIT_SUCCESS);
}
